# -*- coding: utf-8 -*-
"""
Created on Wed Oct 07 11:18:33 2015

"""

import math

class CRiver(object):

    def __init__(self):
        self.Name = 0
        self.Depth = 0.0
        self.Flow = 0.0
        self.Gravity = 9.81
        self.Length = 0.0
        self.MeanVelocity = 0.0
        self.Slope = 0.0
        self.Width = 0.0        
      
# properties
      
    @property
    def Area(self):
        return self.Depth * self.Width  

    @property
    def MeanVelocityToShearVelocityRatio(self):
        assert self.ShearVelocity > 0.0
        return self.MeanVelocity / self.ShearVelocity
        
    @property
    def ShearVelocity(self):
        return math.sqrt(self.Gravity * self.Depth * self.Slope)

    @property
    def WidthToDepthRatio(self):
        assert self.Depth > 0.0
        return self.Width / self.Depth
            
# setters
        
    @Area.setter
    def AreaDepthIsChanged(self, AArea):
        assert (self.Width>0.0)
        self.Depth = AArea / self.Width

    @Area.setter
    def AreaWidthIsChanged(self, AArea):
        assert (self.Depth>0.0)
        self.Width = AArea / self.Depth

# methods
        
    def PrintToConsole(self):
        print ( 'River parameters')
        print ( '----------------')
        print ( 'River.Depth (m) %5.2f' % self.Depth)
        print ( 'River.Width (m) %5.2f' % self.Width)
        print ( 'River.Area (m^2) %5.2f' % self.Area)
        print ( 'River.Width/Depth %5.2f' % self.WidthToDepthRatio)
        print ( 'River.MeanVelocity (m s^-1) %5.2f' % self.MeanVelocity)
        print ( 'River.ShearVelocity (m s^-1) %5.4f' % self.ShearVelocity)
        print ( 'River.Gravity (m s^-2) %5.2f' % self.Gravity)
        print ( 'River.Length (m) %5.2f' % self.Length)
        print ( 'River.MeanVelocity/ShearVelocity %5.2f' % self.MeanVelocityToShearVelocityRatio)
        print ( 'River.Slope %5.4f' % self.Slope)
        print ( '')